//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "relatywstereo.h"
#include "fkostka.h"
#include <math.h>
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner) : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormShow(TObject *Sender)
{
 odczytaj_parametry();
}
//---------------------------------------------------------------------------
// Odczytaj parametry
void TForm1 :: odczytaj_parametry( void)
{
 sp = (StylPatrzenia)RadioGroup1 -> ItemIndex;
 if( sp == Anaglif)
 {
     Lkolor = clRed;
     Rkolor = clAqua;
 }
 else
 {
     Lkolor = Rkolor = clBlack;
 }
 baza = (double)TrackBar1 -> Position / 100.;
 obserwator.x = (double)TrackBar2 -> Position / 10.;
 obserwator.y = (double)TrackBar3 -> Position / 10.;
 obserwator.z = (double)TrackBar4 -> Position / 10.;
 ogniskowa = (double)TrackBar5 -> Position/100.;
 v = N_c * TrackBar6 -> Position / 300.;
}
//---------------------------------------------------------------------------
//  Wykrelenie kostki, rozpitej na podanych wierzchokach
void __fastcall TForm1::PaintBox1Paint(TObject *Sender)
{
 TRelatywStereo rs( obserwator, //pozycja obserwatora
    0, 0, PaintBox1 -> Width, PaintBox1 -> Height, //okienko ekranowe
    v,                          //prdko
    baza,                       //odlego midzy oczami
    PaintBox1 -> Canvas,        //aparat graficzny
    sp,                         //styl projekcji stereo
    ogniskowa);                 //odlego oka od paszczyzny obrazowej

 int il_podzial = 5;
 TPunkt p1(1,1,-1), p2(-1,1,-1), p3(-1,-1,-1), p4(1,-1,-1),
        p5(1,1,1),  p6(-1,1,1),  p7(-1,-1,1),  p8(1,-1,1);

 PaintBox1 -> Canvas -> Brush -> Color = clSilver;
 rs.linia_stereo( p1, p2, il_podzial, Lkolor, Rkolor);
 rs.linia_stereo( p2, p3, il_podzial, Lkolor, Rkolor);
 rs.linia_stereo( p3, p4, il_podzial, Lkolor, Rkolor);
 rs.linia_stereo( p4, p1, il_podzial, Lkolor, Rkolor);

 rs.linia_stereo( p5, p6, il_podzial, Lkolor, Rkolor);
 rs.linia_stereo( p6, p7, il_podzial, Lkolor, Rkolor);
 rs.linia_stereo( p7, p8, il_podzial, Lkolor, Rkolor);
 rs.linia_stereo( p8, p5, il_podzial, Lkolor, Rkolor);

 rs.linia_stereo( p1, p5, il_podzial, Lkolor, Rkolor);
 rs.linia_stereo( p2, p6, il_podzial, Lkolor, Rkolor);
 rs.linia_stereo( p3, p7, il_podzial, Lkolor, Rkolor);
 rs.linia_stereo( p4, p8, il_podzial, Lkolor, Rkolor);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::TrackBar1Change(TObject *Sender)
{
 odczytaj_parametry();
 PaintBox1 -> Refresh();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormKeyPress(TObject *Sender, char &Key)
{
 if( Key == VK_ESCAPE)
    Close();
}
//---------------------------------------------------------------------------

